/* SPDX-License-Identifier: GPL-2.0-only OR MIT */

#ifndef __SOC_MEDIATEK_MT8189_INCLUDE_SOC_CLK_BUF_CTL_H__
#define __SOC_MEDIATEK_MT8189_INCLUDE_SOC_CLK_BUF_CTL_H__

#define MT6359_PMRC_CON0				0x1A6
#define MT6359_TOP_TMA_KEY				0x3A8
#define MT6359_TOP_SPI_CON1				0x458
#define MT6359_XO_BUF_CTL0				0x54C
#define MT6359_XO_BUF_CTL1				0x54E
#define MT6359_XO_BUF_CTL2				0x550
#define MT6359_XO_BUF_CTL3				0x552
#define MT6359_XO_BUF_CTL4				0x554
#define MT6359_XO_CONN_BT0				0x556
#define MT6359_DCXO_CW00				0x788
#define MT6359_DCXO_CW00_SET				0x78A
#define MT6359_DCXO_CW00_CLR				0x78C
#define MT6359_DCXO_CW01				0x78E
#define MT6359_DCXO_CW02				0x790
#define MT6359_DCXO_CW03				0x792
#define MT6359_DCXO_CW04				0x794
#define MT6359_DCXO_CW05				0x796
#define MT6359_DCXO_CW06				0x798
#define MT6359_DCXO_CW07				0x79A
#define MT6359_DCXO_CW08				0x79C
#define MT6359_DCXO_CW09				0x79E
#define MT6359_DCXO_CW09_SET				0x7A0
#define MT6359_DCXO_CW09_CLR				0x7A2
#define MT6359_DCXO_CW10				0x7A4
#define MT6359_DCXO_CW11				0x7A6
#define MT6359_DCXO_CW12				0x7A8
#define MT6359_DCXO_CW13				0x7AA
#define MT6359_DCXO_CW14				0x7AC
#define MT6359_DCXO_CW15				0x7AE
#define MT6359_DCXO_CW16				0x7B0
#define MT6359_DCXO_CW17				0x7B2
#define MT6359_DCXO_CW18				0x7B4
#define MT6359_DCXO_CW19				0x7B6
#define MT6359_LDO_VRFCK_ELR				0x1B40
#define MT6359_LDO_VRFCK_CON0				0x1D1C
#define MT6359_LDO_VRFCK_OP_EN				0x1D22
#define MT6359_LDO_VRFCK_OP_EN_SET			0x1D24
#define MT6359_LDO_VBBCK_CON0				0x1D2E
#define MT6359_LDO_VBBCK_OP_EN				0x1D34
#define MT6359_LDO_VBBCK_OP_EN_SET			0x1D36
#define MT6359_DCXO_ADLDO_BIAS_ELR_0			0x209C
#define MT6359_DCXO_ADLDO_BIAS_ELR_1			0x209E
#define PMIC_RG_SRCLKEN_IN3_EN_ADDR			MT6359_TOP_SPI_CON1
#define PMIC_RG_SRCLKEN_IN3_EN_MASK			0x1
#define PMIC_RG_SRCLKEN_IN3_EN_SHIFT			0
#define PMIC_RG_LDO_VBBCK_HW14_OP_EN_ADDR		MT6359_LDO_VBBCK_OP_EN
#define PMIC_RG_LDO_VBBCK_HW14_OP_EN_MASK		0x1
#define PMIC_RG_LDO_VBBCK_HW14_OP_EN_SHIFT		14
#define PMIC_RG_LDO_VRFCK_HW14_OP_EN_ADDR		MT6359_LDO_VRFCK_OP_EN
#define PMIC_RG_LDO_VRFCK_HW14_OP_EN_MASK		0x1
#define PMIC_RG_LDO_VRFCK_HW14_OP_EN_SHIFT		14
#define PMIC_RG_LDO_VRFCK_EN_ADDR			MT6359_LDO_VRFCK_CON0
#define PMIC_RG_LDO_VRFCK_EN_MASK			0x1
#define PMIC_RG_LDO_VRFCK_EN_SHIFT			0
#define PMIC_RG_LDO_VBBCK_EN_ADDR			MT6359_LDO_VBBCK_CON0
#define PMIC_RG_LDO_VBBCK_EN_MASK			0x1
#define PMIC_RG_LDO_VBBCK_EN_SHIFT			0
#define PMIC_RG_VRFCK_HV_EN_ADDR			MT6359_DCXO_ADLDO_BIAS_ELR_0
#define PMIC_RG_VRFCK_HV_EN_MASK			0x1
#define PMIC_RG_VRFCK_HV_EN_SHIFT			9
#define PMIC_PMRC_EN_ADDR				MT6359_PMRC_CON0
#define PMIC_PMRC_EN_MASK				0xFFFF
#define PMIC_PMRC_EN_SHIFT				0
#define PMIC_TMA_KEY_ADDR				MT6359_TOP_TMA_KEY
#define PMIC_TMA_KEY_MASK				0xFFFF
#define PMIC_TMA_KEY_SHIFT				0
#define PMIC_RG_LDO_VRFCK_ANA_SEL_ADDR			MT6359_LDO_VRFCK_ELR
#define PMIC_RG_LDO_VRFCK_ANA_SEL_MASK			0x1
#define PMIC_RG_LDO_VRFCK_ANA_SEL_SHIFT			0
#define PMIC_RG_VRFCK_NDIS_EN_ADDR			MT6359_DCXO_ADLDO_BIAS_ELR_0
#define PMIC_RG_VRFCK_NDIS_EN_MASK			0x1
#define PMIC_RG_VRFCK_NDIS_EN_SHIFT			11
#define PMIC_RG_LDO_VRFCK_OP_EN_SET_ADDR		MT6359_LDO_VRFCK_OP_EN_SET
#define PMIC_RG_LDO_VBBCK_OP_EN_SET_ADDR		MT6359_LDO_VBBCK_OP_EN_SET
#define PMIC_XO_EXTBUF1_MODE_ADDR			MT6359_DCXO_CW00
#define PMIC_XO_EXTBUF2_MODE_MASK			0x3
#define PMIC_XO_EXTBUF2_MODE_SHIFT			3
#define PMIC_XO_EXTBUF2_EN_M_MASK			0x1
#define PMIC_XO_EXTBUF2_EN_M_SHIFT			5
#define PMIC_XO_EXTBUF4_MODE_MASK			0x3
#define PMIC_XO_EXTBUF4_MODE_SHIFT			9
#define PMIC_XO_EXTBUF4_EN_M_MASK			0x1
#define PMIC_XO_EXTBUF4_EN_M_SHIFT			11
#define PMIC_DCXO_CW00_CLR_ADDR				MT6359_DCXO_CW00_CLR
#define PMIC_XO_CLKSEL_EN_M_ADDR			MT6359_DCXO_CW01

#define PMIC_XO_CDAC_FPM_ADDR                           MT6359_DCXO_CW04
#define PMIC_XO_CDAC_FPM_MASK                           0xFF
#define PMIC_XO_CDAC_FPM_SHIFT                          0
#define PMIC_XO_CDAC_LPM_ADDR                           MT6359_DCXO_CW04
#define PMIC_XO_CDAC_LPM_MASK                           0xFF
#define PMIC_XO_CDAC_LPM_SHIFT                          8

#define PMIC_XO_PMIC_TOP_DIG_SW_ADDR			MT6359_DCXO_CW08
#define PMIC_XO_PMIC_TOP_DIG_SW_MASK			0x1
#define PMIC_XO_PMIC_TOP_DIG_SW_SHIFT			2
#define PMIC_XO_EXTBUF7_MODE_ADDR			MT6359_DCXO_CW09
#define PMIC_XO_EXTBUF2_CLKSEL_MAN_ADDR			MT6359_DCXO_CW12
#define PMIC_XO_EXTBUF2_CLKSEL_MAN_MASK			0x1
#define PMIC_XO_EXTBUF2_CLKSEL_MAN_SHIFT		12
#define PMIC_RG_XO_EXTBUF2_SRSEL_ADDR			MT6359_DCXO_CW13
#define PMIC_RG_XO_EXTBUF2_SRSEL_MASK			0x7
#define PMIC_RG_XO_EXTBUF2_SRSEL_SHIFT			0
#define PMIC_RG_XO_EXTBUF4_SRSEL_ADDR			MT6359_DCXO_CW13
#define PMIC_RG_XO_EXTBUF4_SRSEL_MASK			0x7
#define PMIC_RG_XO_EXTBUF4_SRSEL_SHIFT			4
#define PMIC_RG_XO_EXTBUF3_HD_ADDR			MT6359_DCXO_CW13
#define PMIC_RG_XO_EXTBUF3_HD_MASK			0x3
#define PMIC_RG_XO_EXTBUF3_HD_SHIFT			10
#define PMIC_RG_XO_RESERVED1_ADDR			MT6359_DCXO_CW15
#define PMIC_XO_STATIC_AUXOUT_SEL_ADDR			MT6359_DCXO_CW16
#define PMIC_XO_STATIC_AUXOUT_SEL_MASK			0x3F
#define PMIC_XO_STATIC_AUXOUT_SEL_SHIFT			0
#define PMIC_XO_STATIC_AUXOUT_ADDR			MT6359_DCXO_CW17
#define PMIC_XO_STATIC_AUXOUT_MASK			0xFFFF
#define PMIC_XO_STATIC_AUXOUT_SHIFT			0
#define PMIC_RG_XO_EXTBUF1_RSEL_ADDR			MT6359_DCXO_CW19
#define PMIC_RG_XO_EXTBUF1_RSEL_MASK			0x7
#define PMIC_RG_XO_EXTBUF1_RSEL_SHIFT			1
#define PMIC_RG_XO_EXTBUF2_RSEL_ADDR			MT6359_DCXO_CW19
#define PMIC_RG_XO_EXTBUF2_RSEL_MASK			0x7
#define PMIC_RG_XO_EXTBUF2_RSEL_SHIFT			4
#define PMIC_RG_XO_EXTBUF3_RSEL_ADDR			MT6359_DCXO_CW19
#define PMIC_RG_XO_EXTBUF3_RSEL_MASK			0x7
#define PMIC_RG_XO_EXTBUF3_RSEL_SHIFT			7
#define PMIC_RG_XO_EXTBUF4_RSEL_ADDR			MT6359_DCXO_CW19
#define PMIC_RG_XO_EXTBUF4_RSEL_MASK			0x7
#define PMIC_RG_XO_EXTBUF4_RSEL_SHIFT			10
#define PMIC_RG_XO_EXTBUF7_RSEL_ADDR			MT6359_DCXO_CW19
#define PMIC_RG_XO_EXTBUF7_RSEL_MASK			0x7
#define PMIC_RG_XO_EXTBUF7_RSEL_SHIFT			13
#define PMIC_RG_VRFCK_1_NDIS_EN_ADDR			MT6359_DCXO_ADLDO_BIAS_ELR_1
#define PMIC_RG_VRFCK_1_NDIS_EN_MASK			0x1
#define PMIC_RG_VRFCK_1_NDIS_EN_SHIFT			0
#define PMIC_XO_SOC_VOTE_ADDR				MT6359_XO_BUF_CTL0
#define PMIC_XO_SOC_VOTE_MASK				0x7FF
#define PMIC_XO_SOC_VOTE_SHIFT				0
#define PMIC_XO_WCN_VOTE_ADDR				MT6359_XO_BUF_CTL1
#define PMIC_XO_WCN_VOTE_MASK				0x7FF
#define PMIC_XO_WCN_VOTE_SHIFT				0
#define PMIC_XO_NFC_VOTE_ADDR				MT6359_XO_BUF_CTL2
#define PMIC_XO_NFC_VOTE_MASK				0x7FF
#define PMIC_XO_NFC_VOTE_SHIFT				0
#define PMIC_XO_CEL_VOTE_ADDR				MT6359_XO_BUF_CTL3
#define PMIC_XO_CEL_VOTE_MASK				0x7FF
#define PMIC_XO_CEL_VOTE_SHIFT				0
#define PMIC_XO_EXT_VOTE_ADDR				MT6359_XO_BUF_CTL4
#define PMIC_XO_EXT_VOTE_MASK				0x7FF
#define PMIC_XO_EXT_VOTE_SHIFT				0
#define PMIC_XO_MODE_CONN_BT_MASK_ADDR			MT6359_XO_CONN_BT0
#define PMIC_XO_MODE_CONN_BT_MASK_MASK			0x1
#define PMIC_XO_MODE_CONN_BT_MASK_SHIFT			0
#define PMIC_XO_BUF_CONN_BT_MASK_ADDR			MT6359_XO_CONN_BT0
#define PMIC_XO_BUF_CONN_BT_MASK_MASK			0x1
#define PMIC_XO_BUF_CONN_BT_MASK_SHIFT			1

enum {
	CLOCK_BUFFER_DISABLE,
	CLOCK_BUFFER_SW_CONTROL,
	CLOCK_BUFFER_HW_CONTROL
};

enum {
	CLK_BUF_OUTPUT_IMPEDANCE_0,
	CLK_BUF_OUTPUT_IMPEDANCE_1,
	CLK_BUF_OUTPUT_IMPEDANCE_2,
	CLK_BUF_OUTPUT_IMPEDANCE_3,
	CLK_BUF_OUTPUT_IMPEDANCE_4,
	CLK_BUF_OUTPUT_IMPEDANCE_5,
	CLK_BUF_OUTPUT_IMPEDANCE_6,
	CLK_BUF_OUTPUT_IMPEDANCE_7,
};

enum {
	CLK_BUF_CONTROLS_FOR_DESENSE_0,
	CLK_BUF_CONTROLS_FOR_DESENSE_1,
	CLK_BUF_CONTROLS_FOR_DESENSE_2,
	CLK_BUF_CONTROLS_FOR_DESENSE_3,
	CLK_BUF_CONTROLS_FOR_DESENSE_4,
	CLK_BUF_CONTROLS_FOR_DESENSE_5,
	CLK_BUF_CONTROLS_FOR_DESENSE_6,
	CLK_BUF_CONTROLS_FOR_DESENSE_7,
};

#define CLK_BUF1_STATUS_PMIC			CLOCK_BUFFER_HW_CONTROL
#define CLK_BUF2_STATUS_PMIC			CLOCK_BUFFER_HW_CONTROL
#define CLK_BUF3_STATUS_PMIC			CLOCK_BUFFER_HW_CONTROL
#define CLK_BUF4_STATUS_PMIC			CLOCK_BUFFER_HW_CONTROL
#define CLK_BUF7_STATUS_PMIC			CLOCK_BUFFER_HW_CONTROL
#define PMIC_CLK_BUF1_OUTPUT_IMPEDANCE		CLK_BUF_OUTPUT_IMPEDANCE_6
#define PMIC_CLK_BUF2_OUTPUT_IMPEDANCE		CLK_BUF_OUTPUT_IMPEDANCE_4
#define PMIC_CLK_BUF3_OUTPUT_IMPEDANCE		CLK_BUF_OUTPUT_IMPEDANCE_4
#define PMIC_CLK_BUF4_OUTPUT_IMPEDANCE		CLK_BUF_OUTPUT_IMPEDANCE_4
#define PMIC_CLK_BUF7_OUTPUT_IMPEDANCE		CLK_BUF_OUTPUT_IMPEDANCE_4
#define PMIC_CLK_BUF2_CONTROLS_FOR_DESENSE	CLK_BUF_CONTROLS_FOR_DESENSE_4
#define PMIC_CLK_BUF3_CONTROLS_FOR_DESENSE	CLK_BUF_CONTROLS_FOR_DESENSE_0
#define PMIC_CLK_BUF4_CONTROLS_FOR_DESENSE	CLK_BUF_CONTROLS_FOR_DESENSE_4

int clk_buf_init(void);
u32 clk_buf_get_pmrc_en(void);

#endif
