from __future__ import absolute_import, division, print_function

def get_percentile_for_clashscore(clashscore, resolution=None):
  windowHalfWidth = 0.25

  nSamples = 0
  nWorse   = 0
  if not resolution: # None or 0.  Resol. not defined -- e.g. NMR structures. Compare to full DB.
    minres = 0
    maxres = 9999
  elif(resolution - windowHalfWidth < 0.65):
    minres = 0
    maxres = max(0.65, resolution) + windowHalfWidth
  elif(resolution + windowHalfWidth > 3.25):
    minres = min(3.25, resolution) - windowHalfWidth
    maxres = 9999
  else:
    minres = resolution - windowHalfWidth
    maxres = resolution + windowHalfWidth

  for i in clashscores_by_resolution():
  #[pdbFile,resolution,clashscore]
    if minres <= i[1] <= maxres:
      nSamples += 1
      if i[2] >= clashscore:
        nWorse += 1
  pctRank = int(100.0*nWorse/nSamples)
  return {"minres":minres, "maxres":maxres, "count":nSamples, "percentile":pctRank}

#Clashscore vs. resolution statistics from SCOP 2000 dataset (circa 2004)
#[pdbFile,resolution,clashscore],
def clashscores_by_resolution():
  return [["1ejgH",0.54,0],
["1ucsH",0.62,10.03],
["3al1H",0.75,2.04],
["1hjeH",0.75,17.440001],
["1gciH",0.78,4.55],
["1iuaH",0.8,8.96],
["1gdnH",0.81,17.18],
["1nwzH",0.82,4.69],
["1n55H",0.83,6.7],
["1m40H",0.85,6.18],
["1mc2H",0.85,6.69],
["1muwH",0.86,5.08],
["1g6xH",0.86,11.87],
["1alzH",0.86,18.870001],
["1dy5H",0.87,7.04],
["1gweH",0.88,6.63],
["1etnH",0.89,0],
["1f9yH",0.89,6.47],
["1i1wH",0.89,13.57],
["1oewH",0.9,3.17],
["1ix9H",0.9,6.85],
["1m24H",0.9,7.3],
["1et1H",0.9,8.55],
["1g66H",0.9,14],
["2pvbH",0.91,2.5],
["1iqzH",0.92,3.41],
["1l9lH",0.92,4.67],
["3lztH",0.92,12.58],
["1rb9H",0.92,14.75],
["2fdnH",0.94,1.35],
["1kwfH",0.94,2.3199999],
["1nlsH",0.94,4.51],
["1mxtH",0.95,6.3],
["1ahoH",0.96,3.1500001],
["1ufyH",0.96,4.94],
["1k5cH",0.96,6.18],
["1c75H",0.97,5.79],
["1f94H",0.97,6.85],
["1byiH",0.97,7.49],
["1m1qH",0.97,7.87],
["1ixhH",0.98,2.47],
["1k4iH",0.98,7.96],
["1ug6H",0.99,3.98],
["1ittH",1,0],
["1c7kH",1,2.0699999],
["1eb6H",1,2.6900001],
["2erlH",1,3.53],
["1ga6H",1,5.1],
["1msoH",1,6.39],
["1nqjH",1,7.17],
["1g2yH",1,7.3],
["1o7jH",1,7.31],
["1exrH",1,8.07],
["1lniH",1,8.87],
["1a6mH",1,9.09],
["1lkkH",1,9.15],
["1jfbH",1,9.42],
["1od3H",1,10.07],
["1gkmH",1,11.41],
["1oaiH",1,13.33],
["1mn8H",1,33.07],
["1cxqH",1.02,3.0599999],
["1qtwH",1.02,4.34],
["1cc8H",1.02,9.21],
["1i27H",1.02,13.4],
["1mfmH",1.02,21.940001],
["1kqpH",1.03,5.8],
["1lu0H",1.03,7.53],
["1xy1H",1.04,0],
["1i2tH",1.04,4.15],
["1oe1H",1.04,6.33],
["1d5tH",1.04,6.91],
["1lwbH",1.05,2.74],
["3silH",1.05,2.9000001],
["1fsgH",1.05,3.03],
["1jclH",1.05,3.38],
["1euwH",1.05,5.82],
["1mooH",1.05,5.92],
["1kmvH",1.05,7.5],
["1psrH",1.05,8.92],
["1m9zH",1.05,10.11],
["1m2dH",1.05,10.2],
["1lqtH",1.05,11.99],
["1kjqH",1.05,19.9],
["1qowH",1.0599999,4.23],
["1nkdH",1.0700001,12.89],
["1koiH",1.08,3.83],
["1jbeH",1.08,5.45],
["1ds1H",1.08,6.03],
["1k5nH",1.09,5.02],
["1kzkH",1.09,7.13],
["1jk3H",1.09,9.1],
["1n62H",1.09,13.49],
["2igdH",1.1,1.08],
["1c5eH",1.1,2.4100001],
["1h4gH",1.1,4.67],
["1itxH",1.1,5.75],
["1qj4H",1.1,5.82],
["1ql0H",1.1,6.82],
["1i40H",1.1,6.9],
["1ls1H",1.1,7.45],
["1qlwH",1.1,7.76],
["1l3kH",1.1,9.32],
["1oh0H",1.1,10.43],
["1bkrH",1.1,12.8],
["1f86H",1.1,13.81],
["1gmxH",1.1,29.58],
["1jm1H",1.11,2.71],
["1oc7H",1.11,2.96],
["1jf8H",1.12,3.89],
["1k7cH",1.12,5.08],
["1g2bH",1.12,5.91],
["1n8kH",1.13,5.59],
["1kngH",1.14,3.32],
["1swuH",1.14,6.57],
["1odmH",1.15,3.26],
["1hdoH",1.15,5.71],
["1vfyH",1.15,6.84],
["1h4aH",1.15,8.97],
["1b6gH",1.15,9.09],
["1gwmH",1.15,21.02],
["1hbnH",1.16,5.12],
["1m1nH",1.16,6.57],
["1h4xH",1.16,25.459999],
["1czpH",1.17,6.9],
["1c9oH",1.17,12.84],
["1n3lH",1.1799999,12.66],
["1ubkH",1.1799999,14.65],
["1lqpH",1.1900001,4.8],
["1ifcH",1.1900001,12.82],
["1o7iH",1.2,3.02],
["1kwnH",1.2,3.63],
["1arbH",1.2,4.03],
["1nz0H",1.2,4.15],
["1l0iH",1.2,4.17],
["1qu9H",1.2,4.21],
["1me4H",1.2,5.42],
["1jg1H",1.2,6.07],
["1c0pH",1.2,6.7],
["1bx7H",1.2,6.95],
["1qtnH",1.2,7.36],
["1knmH",1.2,7.48],
["1nwwH",1.2,7.67],
["1munH",1.2,8.04],
["1fyeH",1.2,8.56],
["1m15H",1.2,9.11],
["1gyoH",1.2,9.51],
["2pthH",1.2,9.77],
["1oboH",1.2,10.28],
["1j98H",1.2,11.14],
["1lokH",1.2,15.06],
["1hqjH",1.2,15.81],
["1o08H",1.2,16.18],
["1mj4H",1.2,16.34],
["1ijvH",1.2,17.610001],
["1lc0H",1.2,19.09],
["1cseH",1.2,19.450001],
["1lb3H",1.21,6.62],
["1d4oH",1.21,8.34],
["1kyfH",1.22,7.01],
["1i0vH",1.23,5.45],
["1oi7H",1.23,7.73],
["1nteH",1.24,10.56],
["1gntH",1.25,3.0599999],
["1eaqH",1.25,5.27],
["1o8bH",1.25,5.53],
["3chbH",1.25,5.88],
["1e58H",1.25,6.28],
["2tpsH",1.25,6.81],
["1c1dH",1.25,7.67],
["1j96H",1.25,8.98],
["1m4lH",1.25,9.19],
["1k3xH",1.25,10.47],
["1mf7H",1.25,10.81],
["1j9bH",1.26,7.28],
["1n0qH",1.26,13.3],
["1ctqH",1.26,13.57],
["1gxuH",1.27,11.4],
["1mqkH",1.28,8.06],
["1qksH",1.28,10.62],
["1gkpH",1.29,6.25],
["1bxaH",1.3,2.49],
["1fcyH",1.3,3.0699999],
["1o2dH",1.3,3.5],
["1jcdH",1.3,3.53],
["1eu1H",1.3,3.73],
["1lq9H",1.3,4.45],
["1hdhH",1.3,4.69],
["1nxmH",1.3,5.54],
["1gk9H",1.3,5.75],
["1g61H",1.3,5.8],
["1k3yH",1.3,6.03],
["7fd1H",1.3,6.11],
["1ox0H",1.3,6.73],
["1hyoH",1.3,6.83],
["1ispH",1.3,7.02],
["1jhgH",1.3,8.41],
["1qddH",1.3,8.54],
["1gztH",1.3,9.85],
["1flmH",1.3,9.91],
["1oqvH",1.3,10.11],
["1es9H",1.3,10.12],
["1gz8H",1.3,10.26],
["1hzyH",1.3,10.66],
["1fk5H",1.3,10.73],
["1lzlH",1.3,11.05],
["1jl1H",1.3,12.92],
["1f9vH",1.3,16.35],
["1nuyH",1.3,16.65],
["1dg6H",1.3,17.76],
["1cy5H",1.3,17.99],
["1kmtH",1.3,18.620001],
["1i12H",1.3,28.290001],
["1gwuH",1.3099999,6.9],
["1kgdH",1.3099999,13.72],
["1gxmH",1.3200001,5.66],
["1mkkH",1.3200001,8.15],
["1e7lH",1.3200001,8.53],
["1gpiH",1.3200001,10],
["1lzjH",1.3200001,13.41],
["1ogwH",1.3200001,21.879999],
["1kkoH",1.33,19.370001],
["1utgH",1.34,21.49],
["2lisH",1.35,3.1300001],
["1gyxH",1.35,4.52],
["1kypH",1.35,7.31],
["1e85H",1.35,8.48],
["1gppH",1.35,8.61],
["1e5kH",1.35,11.3],
["1g2rH",1.35,12.01],
["1kufH",1.35,12.73],
["1ijyH",1.35,13.27],
["1pinH",1.35,33.45],
["1lyvH",1.36,7.34],
["1rhsH",1.36,34.36],
["1f1eH",1.37,7.38],
["1jo0H",1.37,12.59],
["1hx0H",1.38,5.71],
["1gvoH",1.38,7.91],
["1jkvH",1.39,4.81],
["1h2wH",1.39,7.46],
["1n8vH",1.39,26.120001],
["1llfH",1.4,4.47],
["1m55H",1.4,5.22],
["1f0iH",1.4,5.42],
["1o98H",1.4,7.12],
["1ezgH",1.4,7.3],
["1kqrH",1.4,7.86],
["1k3iH",1.4,7.87],
["1fo8H",1.4,8.2],
["1o7nH",1.4,8.3],
["1iw0H",1.4,8.5],
["1m1fH",1.4,8.81],
["1en2H",1.4,8.89],
["1eazH",1.4,8.92],
["1gk7H",1.4,9.1],
["1sgpH",1.4,9.13],
["1ygeH",1.4,9.48],
["3vubH",1.4,9.75],
["1fp2H",1.4,10.58],
["1gk8H",1.4,10.66],
["1qopH",1.4,10.95],
["4eugH",1.4,10.99],
["1n13H",1.4,11.34],
["1l6rH",1.4,11.35],
["1obdH",1.4,11.49],
["1mnnH",1.4,12.13],
["1fw9H",1.4,12.26],
["1m22H",1.4,12.4],
["1gp0H",1.4,12.53],
["256bH",1.4,12.67],
["1jy2H",1.4,12.81],
["1ng6H",1.4,12.89],
["1svfH",1.4,13.13],
["1k7jH",1.4,13.21],
["1ltzH",1.4,13.91],
["1htyH",1.4,15.56],
["1ew4H",1.4,16.25],
["1ifrH",1.4,17.09],
["1ew0H",1.4,21.48],
["1kr4H",1.4,23.290001],
["1qgvH",1.4,30.860001],
["1o04H",1.42,4.57],
["1m7gH",1.4299999,8.1],
["1m0kH",1.4299999,28.41],
["1kb0H",1.4400001,10.77],
["1qh5H",1.45,4.51],
["1fm0H",1.45,4.61],
["1lriH",1.45,5.31],
["1gvdH",1.45,5.41],
["1i88H",1.45,5.77],
["1goiH",1.45,6.54],
["1o06H",1.45,6.58],
["1abaH",1.45,7.74],
["1gvfH",1.45,8.23],
["1is3H",1.45,8.23],
["1lw9H",1.45,8.63],
["1di6H",1.45,8.65],
["1hztH",1.45,8.99],
["1kw3H",1.45,8.99],
["1hz4H",1.45,9.32],
["1i71H",1.45,10.05],
["1ji7H",1.45,10.49],
["1idpH",1.45,10.96],
["1qqfH",1.45,10.97],
["1io0H",1.45,11.46],
["1thfH",1.45,11.89],
["1ikpH",1.45,11.92],
["1n7sH",1.45,12.43],
["1bgfH",1.45,13.15],
["2endH",1.45,13.19],
["1lm4H",1.45,13.6],
["1c1kH",1.45,15.89],
["1jboH",1.45,16.49],
["1c8cH",1.45,29.469999],
["1qreH",1.46,7.8],
["1g3pH",1.46,9.3],
["1lc5H",1.46,9.4],
["1gv9H",1.46,12.67],
["1fx2H",1.46,22.639999],
["1m2kH",1.47,54.12],
["1g6uH",1.48,7.89],
["1l7mH",1.48,8.83],
["1ucaH",1.48,9.42],
["3sebH",1.48,9.75],
["1gqiH",1.48,9.8],
["8abpH",1.49,9.82],
["1my7H",1.49,36.59],
["1l7lH",1.5,0.57],
["1ocyH",1.5,1.65],
["2engH",1.5,3.37],
["1nwaH",1.5,3.39],
["1fr3H",1.5,3.63],
["1gd0H",1.5,3.7],
["1dp7H",1.5,4.5],
["1ofzH",1.5,4.71],
["1m7jH",1.5,4.77],
["1brtH",1.5,4.78],
["1lr7H",1.5,4.89],
["1kgsH",1.5,4.97],
["1g6sH",1.5,5.02],
["1dciH",1.5,5.46],
["1nf9H",1.5,5.76],
["3ezmH",1.5,5.97],
["1mlaH",1.5,6.02],
["1iomH",1.5,6.12],
["1ezmH",1.5,6.17],
["1k20H",1.5,6.91],
["1nytH",1.5,7.01],
["1h05H",1.5,7.04],
["1km4H",1.5,7.09],
["1kr7H",1.5,7.14],
["2mcmH",1.5,7.16],
["1a4iH",1.5,7.22],
["1lv7H",1.5,7.26],
["1jl0H",1.5,7.39],
["1f9zH",1.5,7.51],
["1ig5H",1.5,7.53],
["1e19H",1.5,7.53],
["1opdH",1.5,7.7],
["1cruH",1.5,7.96],
["1bx4H",1.5,8.19],
["1koeH",1.5,8.22],
["1dqzH",1.5,8.29],
["1cipH",1.5,8.33],
["2arcH",1.5,8.7],
["1egwH",1.5,8.97],
["1pefH",1.5,9.15],
["1whiH",1.5,9.29],
["1nziH",1.5,9.37],
["1qczH",1.5,9.66],
["1inlH",1.5,9.72],
["1qg8H",1.5,9.75],
["1o6vH",1.5,9.79],
["1lucH",1.5,10.17],
["1ej0H",1.5,10.5],
["1iq6H",1.5,10.52],
["1o9gH",1.5,10.58],
["1m2xH",1.5,10.65],
["1qqqH",1.5,10.99],
["1jz8H",1.5,11.05],
["1od6H",1.5,11.56],
["1hw1H",1.5,11.81],
["1ntvH",1.5,11.85],
["1i0rH",1.5,12.63],
["1k7kH",1.5,12.68],
["1mg4H",1.5,12.79],
["1i52H",1.5,12.91],
["1dj0H",1.5,12.93],
["1aieH",1.5,13.49],
["1elkH",1.5,13.63],
["1ekqH",1.5,13.81],
["1jr8H",1.5,13.82],
["1ijqH",1.5,14.15],
["1qe3H",1.5,14.46],
["1p1mH",1.5,14.51],
["1c4oH",1.5,14.82],
["1lmiH",1.5,15.1],
["1j77H",1.5,15.14],
["1dfmH",1.5,15.33],
["1wfbH",1.5,15.52],
["1mtpH",1.5,15.56],
["1f46H",1.5,16.08],
["1d7pH",1.5,16.41],
["1n7oH",1.5,16.51],
["1byqH",1.5,16.75],
["1l7aH",1.5,17.200001],
["1fl0H",1.5,17.65],
["1gs5H",1.5,17.68],
["1ah7H",1.5,17.690001],
["1fj2H",1.5,17.77],
["1b8oH",1.5,17.799999],
["1krhH",1.5,17.98],
["1kpfH",1.5,18.549999],
["1gmuH",1.5,20.42],
["1cs1H",1.5,20.75],
["1f7lH",1.5,21.629999],
["1b0uH",1.5,22.120001],
["1irqH",1.5,22.42],
["1nlqH",1.5,22.870001],
["1edmH",1.5,32.16],
["1lo7H",1.5,33.35],
["1h32H",1.5,34.52],
["1lyqH",1.5,39.4],
["1qhvH",1.51,5.04],
["1t1dH",1.51,12.64],
["1hq1H",1.52,13.08],
["1oznH",1.52,14.46],
["1iv3H",1.52,14.97],
["1qq5H",1.52,14.99],
["1h16H",1.53,15.9],
["1j6zH",1.54,8.9],
["3grsH",1.54,9.1],
["1dlwH",1.54,9.78],
["1l2hH",1.54,9.92],
["1dypH",1.54,10.28],
["1orcH",1.54,14.11],
["1dl2H",1.54,18.969999],
["1na3H",1.55,3.68],
["4ubpH",1.55,7.34],
["1mv8H",1.55,8.31],
["1nthH",1.55,9.2],
["1d2sH",1.55,10.42],
["1jkeH",1.55,11.18],
["1nogH",1.55,11.93],
["1f0lH",1.55,11.99],
["1hqsH",1.55,12.49],
["1j34H",1.55,13.61],
["1a62H",1.55,13.73],
["1l2pH",1.55,13.88],
["1h99H",1.55,14.36],
["1nc7H",1.55,14.46],
["1mg7H",1.55,14.66],
["1evlH",1.55,16.9],
["1uteH",1.55,17.190001],
["1ugiH",1.55,18.85],
["1kq1H",1.55,19.99],
["1ihrH",1.55,20.280001],
["1eyhH",1.5599999,8.96],
["2a0bH",1.5700001,5.4],
["1m65H",1.5700001,8.69],
["1moqH",1.5700001,10.39],
["1a8dH",1.5700001,13.49],
["1dk8H",1.5700001,13.8],
["1jovH",1.5700001,19.969999],
["1ju3H",1.58,4.32],
["1ms9H",1.58,8.04],
["1awsH",1.58,22.370001],
["1noxH",1.59,3.7],
["1k7iH",1.59,6.83],
["3pviH",1.59,10.24],
["1o1zH",1.6,2.99],
["1b6aH",1.6,5.24],
["1h2cH",1.6,5.31],
["1j2jH",1.6,5.32],
["1hfeH",1.6,6.16],
["1a8eH",1.6,6.36],
["1b8zH",1.6,6.41],
["1lamH",1.6,6.42],
["1of4H",1.6,6.68],
["1qmgH",1.6,7.04],
["1ccwH",1.6,7.18],
["1bfdH",1.6,7.28],
["1l5oH",1.6,7.34],
["1k92H",1.6,7.57],
["1juhH",1.6,7.68],
["1aquH",1.6,7.68],
["1fi2H",1.6,7.72],
["1iupH",1.6,7.73],
["1g87H",1.6,8.31],
["1elwH",1.6,8.67],
["3nulH",1.6,9.1],
["1nfpH",1.6,9.11],
["1a1iH",1.6,9.5],
["1n2eH",1.6,9.54],
["1fbnH",1.6,9.72],
["1kwmH",1.6,9.73],
["1n08H",1.6,10.17],
["1hqkH",1.6,10.32],
["1l9xH",1.6,10.32],
["1euvH",1.6,10.44],
["1nc5H",1.6,10.45],
["1m7yH",1.6,10.68],
["1kyhH",1.6,10.83],
["1uaqH",1.6,10.86],
["1zinH",1.6,10.94],
["1qgiH",1.6,11],
["1i60H",1.6,11.58],
["1h80H",1.6,11.63],
["1dj7H",1.6,11.7],
["1kqfH",1.6,11.83],
["1kwgH",1.6,12],
["1mk0H",1.6,12.22],
["1aopH",1.6,12.31],
["1g6gH",1.6,12.44],
["1fcqH",1.6,12.55],
["1iu8H",1.6,12.56],
["1jkxH",1.6,12.93],
["7odcH",1.6,13.02],
["1n57H",1.6,13.16],
["16pkH",1.6,13.28],
["1jnrH",1.6,13.37],
["1eyvH",1.6,13.8],
["1o97H",1.6,14.36],
["1gvpH",1.6,14.44],
["1gpqH",1.6,14.53],
["1mrjH",1.6,14.56],
["153lH",1.6,14.68],
["1e2wH",1.6,15.03],
["1b3aH",1.6,15.29],
["1in4H",1.6,15.57],
["1hozH",1.6,15.67],
["1jhjH",1.6,15.92],
["1werH",1.6,15.99],
["1lj9H",1.6,16.049999],
["1k4nH",1.6,16.26],
["1fr2H",1.6,16.450001],
["1o26H",1.6,16.620001],
["1j3aH",1.6,16.629999],
["1nm8H",1.6,16.77],
["1bd0H",1.6,16.9],
["1jatH",1.6,17.1],
["1dd9H",1.6,17.190001],
["1vccH",1.6,17.379999],
["1i58H",1.6,17.51],
["1bfgH",1.6,17.66],
["1eonH",1.6,18.959999],
["1kafH",1.6,19.530001],
["1m4jH",1.6,19.799999],
["1gy6H",1.6,19.870001],
["1g4yH",1.6,20.25],
["1ohlH",1.6,21.879999],
["1fiuH",1.6,22.75],
["2ilkH",1.6,23.68],
["2cuaH",1.6,24.360001],
["1g8qH",1.6,25.280001],
["1d8wH",1.6,26.469999],
["1jb3H",1.6,29.790001],
["1fwxH",1.6,34.98],
["1on2H",1.61,18.610001],
["1m26H",1.62,6.71],
["1d0dH",1.62,7.15],
["1iatH",1.62,9.81],
["1gnyH",1.63,2.22],
["1dzoH",1.63,2.4000001],
["1qgwH",1.63,5.97],
["1jjyH",1.63,11.37],
["1k77H",1.63,12.71],
["1qsaH",1.65,2.5999999],
["1kcqH",1.65,3.2],
["1dhnH",1.65,7.23],
["1i9sH",1.65,8.05],
["1jixH",1.65,9.1],
["1l6pH",1.65,9.15],
["1h9mH",1.65,9.16],
["1qtxH",1.65,9.46],
["1jfxH",1.65,9.9],
["1dtdH",1.65,9.98],
["1o9wH",1.65,10.56],
["1dwkH",1.65,11.58],
["1hx6H",1.65,12.43],
["1hxrH",1.65,12.59],
["1cqmH",1.65,12.62],
["1tx4H",1.65,13.38],
["1onwH",1.65,13.84],
["1ezwH",1.65,15.83],
["1l8rH",1.65,17.360001],
["1d0cH",1.65,17.559999],
["1gxrH",1.65,17.82],
["1oxsH",1.65,17.969999],
["1l6xH",1.65,17.969999],
["1qjpH",1.65,18.49],
["1iwlH",1.65,19.27],
["1mvfH",1.65,21.49],
["1gteH",1.65,22.110001],
["1fjjH",1.66,4.22],
["4uagH",1.66,8.21],
["2hmzH",1.66,8.27],
["1e4cH",1.66,8.69],
["1vnsH",1.66,10.73],
["1fxoH",1.66,14.44],
["1gtkH",1.66,15],
["1l3lH",1.66,20.18],
["1n1jH",1.67,6.8],
["1f60H",1.67,9.6],
["1k1eH",1.67,15.52],
["1ns5H",1.6799999,17.049999],
["1jy1H",1.6900001,9.26],
["2hftH",1.6900001,15.09],
["1gaiH",1.7,3.0599999],
["1obfH",1.7,3.35],
["1mofH",1.7,3.6],
["1dszH",1.7,4.44],
["1qhoH",1.7,4.81],
["1lj8H",1.7,5.64],
["1dqgH",1.7,5.78],
["1kidH",1.7,5.81],
["1nepH",1.7,5.84],
["1nrjH",1.7,6.19],
["1hp1H",1.7,6.45],
["1a8oH",1.7,6.52],
["1dmgH",1.7,6.64],
["1qcxH",1.7,7.26],
["2ahjH",1.7,7.41],
["1fvkH",1.7,7.53],
["1uekH",1.7,7.59],
["1ajjH",1.7,7.72],
["1ctfH",1.7,7.94],
["1p5vH",1.7,7.96],
["1h6hH",1.7,8.42],
["1dqiH",1.7,8.43],
["1l3sH",1.7,8.43],
["1akoH",1.7,8.57],
["1mjhH",1.7,8.67],
["1ornH",1.7,8.79],
["1i19H",1.7,8.9],
["1ftrH",1.7,8.95],
["1pdoH",1.7,9],
["1d02H",1.7,9.03],
["1ay7H",1.7,9.03],
["1hjzH",1.7,9.52],
["1n0wH",1.7,9.56],
["2bopH",1.7,9.61],
["1nvmH",1.7,9.68],
["1jhdH",1.7,9.8],
["1k94H",1.7,9.84],
["1k4gH",1.7,9.94],
["1mwvH",1.7,10.03],
["1molH",1.7,10.24],
["1gs9H",1.7,10.52],
["1qd1H",1.7,10.98],
["1fltH",1.7,11.06],
["1a12H",1.7,11.85],
["1erzH",1.7,12.12],
["1f5nH",1.7,12.3],
["1b2pH",1.7,12.47],
["1h03H",1.7,12.86],
["1bgcH",1.7,12.95],
["1m33H",1.7,12.96],
["1jw9H",1.7,13.04],
["1k0rH",1.7,13.08],
["1j83H",1.7,13.19],
["1d3vH",1.7,13.25],
["1izcH",1.7,13.92],
["1kzqH",1.7,14.19],
["1duvH",1.7,14.4],
["1kaeH",1.7,14.65],
["1fndH",1.7,14.71],
["1igqH",1.7,14.71],
["1dmhH",1.7,15.08],
["1m9xH",1.7,15.25],
["1mogH",1.7,15.31],
["1n6aH",1.7,15.32],
["1ks9H",1.7,15.44],
["1o0iH",1.7,15.68],
["1gx5H",1.7,15.69],
["1ogqH",1.7,16.25],
["1p1jH",1.7,16.290001],
["1jm0H",1.7,16.450001],
["1vhhH",1.7,16.870001],
["1mxiH",1.7,17.139999],
["1h6fH",1.7,17.76],
["1pe0H",1.7,17.790001],
["1dbgH",1.7,17.940001],
["1dc1H",1.7,18.18],
["1gx3H",1.7,18.18],
["1jx4H",1.7,18.51],
["1gmiH",1.7,18.74],
["1aqzH",1.7,19.08],
["1vieH",1.7,20.110001],
["1eexH",1.7,20.32],
["1eyeH",1.7,21.190001],
["1nqzH",1.7,21.370001],
["1f3uH",1.7,21.66],
["1josH",1.7,22.110001],
["1ddwH",1.7,22.690001],
["1d4aH",1.7,24.059999],
["1azoH",1.7,24.09],
["1mgqH",1.7,24.139999],
["1njhH",1.7,24.32],
["1mtyH",1.7,24.370001],
["1ewfH",1.7,25.629999],
["1pmiH",1.7,26.83],
["1htwH",1.7,28.42],
["1tfeH",1.7,28.5],
["1j79H",1.7,32.91],
["1ij2H",1.7,33.88],
["1p3qH",1.7,34.6],
["1mz9H",1.7,46.24],
["1gxyH",1.71,10.42],
["1gyvH",1.71,12.88],
["1d0qH",1.71,13.42],
["1gwyH",1.71,13.71],
["1jmkH",1.71,14.62],
["1bm8H",1.71,23.790001],
["1lfpH",1.72,68.41],
["1jtgH",1.73,9.36],
["1fs5H",1.73,21.700001],
["1pcfH",1.74,6.04],
["1g60H",1.74,7.25],
["1ldgH",1.74,8.69],
["1qf8H",1.74,9.37],
["1jiwH",1.74,10.53],
["1jyaH",1.74,23.85],
["1gq8H",1.75,5.62],
["1o3uH",1.75,5.91],
["1kptH",1.75,7.09],
["1kw4H",1.75,7.25],
["3claH",1.75,8.05],
["1gqzH",1.75,8.29],
["1gtfH",1.75,8.44],
["1chdH",1.75,9.12],
["1k2yH",1.75,9.4],
["1behH",1.75,9.97],
["2bbkH",1.75,10.15],
["1ed9H",1.75,10.51],
["1jakH",1.75,10.52],
["1oi2H",1.75,10.79],
["1k6wH",1.75,11.04],
["1nrzH",1.75,11.28],
["1b9mH",1.75,11.68],
["1f32H",1.75,12.78],
["1mixH",1.75,12.95],
["1nszH",1.75,13.03],
["1n8fH",1.75,13.6],
["1go3H",1.75,13.71],
["1avwH",1.75,14.04],
["1g8mH",1.75,14.66],
["1bkbH",1.75,14.97],
["1pg4H",1.75,15.59],
["1d2vH",1.75,15.76],
["1iktH",1.75,15.86],
["1cqxH",1.75,16.1],
["1ne2H",1.75,16.889999],
["1hm9H",1.75,17.35],
["3htsH",1.75,17.969999],
["1j8bH",1.75,18.18],
["1gnuH",1.75,18.700001],
["1l1lH",1.75,20.219999],
["1k9uH",1.75,22.379999],
["1evyH",1.75,23.219999],
["1h5uH",1.76,14.79],
["1dk0H",1.77,10.12],
["1f0jH",1.77,16.57],
["1lplH",1.77,18.120001],
["1qazH",1.78,6.36],
["1oi1H",1.78,10.51],
["1axnH",1.78,18.940001],
["1j23H",1.78,20.43],
["1iabH",1.79,5.3],
["1dxgH",1.8,2.99],
["1kp6H",1.8,4.32],
["2porH",1.8,4.65],
["1bdoH",1.8,4.8],
["1h6lH",1.8,4.85],
["1kveH",1.8,4.89],
["1iibH",1.8,4.98],
["1vsrH",1.8,5.08],
["1fe6H",1.8,5.49],
["1mgtH",1.8,5.52],
["3proH",1.8,5.93],
["2sakH",1.8,6.02],
["1dqsH",1.8,6.09],
["1jyhH",1.8,6.1],
["1m3uH",1.8,6.33],
["1o6sH",1.8,6.69],
["2dpmH",1.8,6.72],
["1fn9H",1.8,6.74],
["1jidH",1.8,6.77],
["1a73H",1.8,7.54],
["1n9pH",1.8,7.73],
["1e1hH",1.8,7.81],
["1a3aH",1.8,8.25],
["1uroH",1.8,8.56],
["1b9wH",1.8,8.65],
["1tyuH",1.8,8.65],
["1dpjH",1.8,8.74],
["1bb1H",1.8,8.82],
["1ak0H",1.8,8.94],
["1m0wH",1.8,9.26],
["1c3cH",1.8,9.26],
["1c02H",1.8,9.35],
["1dl5H",1.8,9.56],
["1vcaH",1.8,9.67],
["1qo7H",1.8,9.72],
["1toaH",1.8,9.9],
["1mhnH",1.8,9.9],
["1ualH",1.8,9.97],
["1h70H",1.8,9.97],
["1qnaH",1.8,9.99],
["1dozH",1.8,10.3],
["1dowH",1.8,10.6],
["1iirH",1.8,10.83],
["1g55H",1.8,11.05],
["2baaH",1.8,11.25],
["1a92H",1.8,11.29],
["1cf9H",1.8,11.81],
["1h72H",1.8,11.93],
["2nacH",1.8,12.04],
["1jhfH",1.8,12.11],
["1oneH",1.8,12.14],
["1dbxH",1.8,12.15],
["1nh8H",1.8,12.16],
["1mpgH",1.8,12.25],
["2sliH",1.8,12.31],
["1cl8H",1.8,12.38],
["1khcH",1.8,12.42],
["1jp3H",1.8,12.83],
["1e1aH",1.8,12.84],
["1npkH",1.8,12.95],
["1jsdH",1.8,12.95],
["1bu8H",1.8,12.99],
["1ld8H",1.8,13.49],
["1k0iH",1.8,14.05],
["1mskH",1.8,14.05],
["1uxyH",1.8,14.11],
["1mugH",1.8,14.19],
["1pymH",1.8,14.21],
["1h4rH",1.8,14.23],
["1jtaH",1.8,14.27],
["2tgiH",1.8,14.27],
["1mwpH",1.8,14.4],
["1ny1H",1.8,14.62],
["1uchH",1.8,14.73],
["1gdoH",1.8,14.83],
["1dqeH",1.8,14.92],
["1tifH",1.8,15.01],
["1j6oH",1.8,15.37],
["1rtmH",1.8,15.52],
["1sluH",1.8,15.58],
["1k6kH",1.8,15.61],
["1fpoH",1.8,15.75],
["1j8rH",1.8,15.86],
["1fc6H",1.8,16.07],
["1mwxH",1.8,16.24],
["1kzfH",1.8,16.309999],
["1c7sH",1.8,16.41],
["1ivwH",1.8,16.41],
["1oxjH",1.8,16.68],
["1mtzH",1.8,16.809999],
["1e6cH",1.8,17],
["1aylH",1.8,17.040001],
["1orvH",1.8,17.059999],
["1dinH",1.8,17.07],
["1f1mH",1.8,17.309999],
["1cy9H",1.8,17.85],
["1j09H",1.8,17.879999],
["1mh9H",1.8,17.959999],
["1lxjH",1.8,19.1],
["1lbuH",1.8,19.24],
["1ig0H",1.8,19.299999],
["1dfuH",1.8,19.459999],
["3eipH",1.8,19.459999],
["1iz5H",1.8,19.629999],
["1l8bH",1.8,19.68],
["1i9zH",1.8,20.07],
["1pgsH",1.8,20.540001],
["1dusH",1.8,20.67],
["1guqH",1.8,21.219999],
["1lfwH",1.8,21.809999],
["1f0yH",1.8,21.91],
["1nkpH",1.8,21.98],
["1bg6H",1.8,22.09],
["1lvmH",1.8,22.190001],
["1hxnH",1.8,22.23],
["1jh6H",1.8,22.440001],
["1nxuH",1.8,23.16],
["3magH",1.8,23.309999],
["1khxH",1.8,23.67],
["1i4jH",1.8,23.959999],
["1ja1H",1.8,24.67],
["1iq4H",1.8,25.280001],
["1lb6H",1.8,25.52],
["1bd8H",1.8,25.559999],
["1ku3H",1.8,25.59],
["3bamH",1.8,25.76],
["1mmlH",1.8,25.76],
["1lm5H",1.8,26.18],
["1iqcH",1.8,26.52],
["1a9xH",1.8,27.110001],
["1g8eH",1.8,30.629999],
["1g9zH",1.8,30.700001],
["1qnfH",1.8,31.32],
["1m1sH",1.8,33.29],
["1hcrH",1.8,34.08],
["1h7cH",1.8,34.12],
["3sicH",1.8,36.05],
["1c3pH",1.8,41.57],
["1e0tH",1.8,46.54],
["2spcH",1.8,53.51],
["1fs1H",1.8,77.03],
["1c96H",1.8099999,14.57],
["1a34H",1.8099999,14.98],
["1gqeH",1.8099999,18.35],
["1l7dH",1.8099999,20.639999],
["1b65H",1.8200001,12.19],
["1h8pH",1.8200001,13.83],
["1iyeH",1.8200001,16.98],
["1hw5H",1.8200001,32.67],
["1o13H",1.83,2.72],
["1hq0H",1.83,8.44],
["1jr2H",1.84,17.690001],
["1b25H",1.85,8.14],
["1extH",1.85,9.52],
["1k8wH",1.85,10.48],
["1l1dH",1.85,11.18],
["1tolH",1.85,11.21],
["1cqqH",1.85,16.120001],
["1f4lH",1.85,16.18],
["1j75H",1.85,17.65],
["3fapH",1.85,18.360001],
["1jbwH",1.85,19.82],
["1eyqH",1.85,20.01],
["1ex2H",1.85,20.24],
["1lm8H",1.85,20.67],
["1oo0H",1.85,22.719999],
["1l8aH",1.85,23.280001],
["1avyH",1.85,24.6],
["1guxH",1.85,26.110001],
["1cq3H",1.85,26.360001],
["1vlsH",1.85,34.59],
["1lmlH",1.86,10.43],
["1g1jH",1.86,15.04],
["1khdH",1.86,17.84],
["1e6iH",1.87,10.39],
["1h1yH",1.87,12.43],
["1gyhH",1.89,6.32],
["1nnwH",1.9,2.1099999],
["1c2aH",1.9,2.8499999],
["1o4wH",1.9,4.11],
["1ailH",1.9,4.42],
["1slmH",1.9,5.05],
["1h6wH",1.9,5.16],
["1o1xH",1.9,5.22],
["1pl3H",1.9,5.74],
["1jd5H",1.9,6.67],
["1k30H",1.9,6.8],
["1whoH",1.9,6.84],
["1cpoH",1.9,7.43],
["1i8aH",1.9,7.52],
["1vpsH",1.9,7.7],
["1rsyH",1.9,7.79],
["1guiH",1.9,8.1],
["1ae9H",1.9,8.21],
["1rh4H",1.9,8.36],
["1bxyH",1.9,8.45],
["1eybH",1.9,8.5],
["1d2tH",1.9,8.91],
["1e0bH",1.9,9.09],
["1qmyH",1.9,9.18],
["1nxjH",1.9,9.24],
["1lu9H",1.9,9.51],
["1mkyH",1.9,9.76],
["1jfrH",1.9,9.79],
["1c1yH",1.9,9.84],
["1ad2H",1.9,9.95],
["1svbH",1.9,10.08],
["1b66H",1.9,10.16],
["1b0nH",1.9,10.29],
["1hn0H",1.9,10.49],
["1ci4H",1.9,10.6],
["1g72H",1.9,10.86],
["1epwH",1.9,11.13],
["1a8lH",1.9,11.31],
["1eejH",1.9,11.34],
["1b5qH",1.9,11.36],
["1czaH",1.9,11.43],
["1jhsH",1.9,11.58],
["1qnxH",1.9,11.77],
["1jflH",1.9,11.84],
["1dzfH",1.9,11.87],
["1jk7H",1.9,11.89],
["1j9lH",1.9,12.19],
["1ei5H",1.9,12.22],
["1dtoH",1.9,12.23],
["1jdhH",1.9,12.24],
["1li1H",1.9,12.48],
["1ll2H",1.9,12.51],
["1soxH",1.9,12.83],
["1b8aH",1.9,13.06],
["1ayoH",1.9,13.07],
["1k6dH",1.9,13.13],
["1qcsH",1.9,13.51],
["1ef1H",1.9,13.59],
["1oaoH",1.9,13.74],
["1gprH",1.9,13.82],
["1m0dH",1.9,13.87],
["1fkmH",1.9,14],
["1etxH",1.9,14.33],
["1at0H",1.9,14.34],
["1on3H",1.9,14.74],
["1b93H",1.9,14.82],
["1i7nH",1.9,14.9],
["1n67H",1.9,15.14],
["1phmH",1.9,15.18],
["1rypH",1.9,15.21],
["1jdwH",1.9,15.59],
["1ib2H",1.9,15.84],
["1jyoH",1.9,16.26],
["1f08H",1.9,16.440001],
["1seiH",1.9,16.709999],
["1ez3H",1.9,17.43],
["1nj4H",1.9,17.51],
["1regH",1.9,17.59],
["1hx1H",1.9,17.68],
["1ca1H",1.9,17.780001],
["2hddH",1.9,18.370001],
["1obbH",1.9,18.66],
["1kekH",1.9,18.889999],
["1n9lH",1.9,19.02],
["1nriH",1.9,19.129999],
["1f00H",1.9,19.15],
["1iwmH",1.9,19.190001],
["1rssH",1.9,19.24],
["1f5mH",1.9,19.700001],
["1oisH",1.9,19.799999],
["1musH",1.9,19.860001],
["1ivnH",1.9,20.719999],
["1p4kH",1.9,21.01],
["1chmH",1.9,21.129999],
["4bclH",1.9,21.27],
["1jmxH",1.9,21.33],
["1di2H",1.9,21.5],
["1qqpH",1.9,21.68],
["1i1qH",1.9,21.719999],
["2piiH",1.9,21.92],
["1iowH",1.9,22.32],
["7ahlH",1.9,22.33],
["1bazH",1.9,22.35],
["1b63H",1.9,22.51],
["1f0kH",1.9,22.75],
["1f0xH",1.9,23.280001],
["1e3oH",1.9,23.469999],
["1c8uH",1.9,23.73],
["1k12H",1.9,24.030001],
["1efdH",1.9,24.34],
["1m6yH",1.9,27.33],
["1g4mH",1.9,30.860001],
["1ezjH",1.9,33.46],
["1n5uH",1.9,34],
["1orsH",1.9,34.74],
["1gu9H",1.9,35.64],
["1cukH",1.9,35.77],
["1fleH",1.9,35.81],
["1lshH",1.9,35.89],
["1lvkH",1.9,35.93],
["1c8zH",1.9,38.58],
["1zfjH",1.9,39.54],
["1eerH",1.9,40.44],
["1lslH",1.9,42.8],
["1qr0H",1.9,50.57],
["1qb0H",1.91,13.58],
["1jqeH",1.91,16.1],
["1ikoH",1.92,19.719999],
["1ku1H",1.9299999,13.61],
["1ekjH",1.9299999,21.040001],
["1bc8H",1.9299999,24.1],
["1jztH",1.9400001,12.52],
["1kblH",1.9400001,19.709999],
["1kx5H",1.9400001,25.35],
["1ptqH",1.95,5.06],
["1o4tH",1.95,6.78],
["1klxH",1.95,9.69],
["1pucH",1.95,9.78],
["1o75H",1.95,12.35],
["1itwH",1.95,12.97],
["1qhdH",1.95,14.02],
["1mdwH",1.95,14.29],
["1ni4H",1.95,14.74],
["1gvnH",1.95,15.67],
["2pspH",1.95,15.83],
["1ko7H",1.95,16.879999],
["1ospH",1.95,17.84],
["1icxH",1.95,18.43],
["1g8fH",1.95,19.76],
["1a4mH",1.95,20.07],
["1l3iH",1.95,22.709999],
["1hs6H",1.95,25.32],
["1k04H",1.95,25.790001],
["1b12H",1.95,26.040001],
["1gpjH",1.95,27.32],
["1crzH",1.95,30.34],
["1g8lH",1.95,30.530001],
["1m1hH",1.95,42.63],
["1beaH",1.95,44.23],
["1h7mH",1.96,10.2],
["1lg7H",1.96,26.059999],
["1m5wH",1.96,32.02],
["1l3pH",1.98,8.05],
["1i9gH",1.98,13.27],
["1by2H",2,3.0899999],
["1qoyH",2,4.39],
["1tl2H",2,5.74],
["1d2zH",2,5.96],
["1ct5H",2,6.84],
["1nbaH",2,6.99],
["1o22H",2,7.05],
["1oe4H",2,7.08],
["1mkaH",2,7.6],
["1mbyH",2,7.75],
["1plzH",2,7.8],
["1gsaH",2,7.88],
["2mltH",2,7.97],
["1he1H",2,8.26],
["1hoeH",2,8.35],
["5csmH",2,8.4],
["1xerH",2,8.53],
["2sqcH",2,8.56],
["1qlmH",2,8.74],
["1j5uH",2,9.01],
["1ni9H",2,9.13],
["1pprH",2,9.18],
["1cozH",2,9.18],
["1h3nH",2,9.66],
["1kskH",2,9.69],
["1cvrH",2,9.69],
["1sraH",2,10.4],
["1dvoH",2,10.48],
["1a1xH",2,10.94],
["1dkzH",2,10.97],
["1dxrH",2,11.03],
["1gl4H",2,11.21],
["1surH",2,11.5],
["1reqH",2,11.8],
["1n1bH",2,11.88],
["1mvlH",2,12.88],
["4mt2H",2,12.97],
["1h1dH",2,12.99],
["1ituH",2,13.03],
["1g13H",2,13.1],
["1bm9H",2,13.53],
["1fc3H",2,13.59],
["1p42H",2,13.68],
["1i36H",2,13.91],
["1a6qH",2,14.14],
["1ekrH",2,14.17],
["1aolH",2,14.25],
["1ga8H",2,14.26],
["1eg3H",2,14.61],
["1o8aH",2,14.63],
["3tdtH",2,14.77],
["1o0wH",2,14.78],
["1hb6H",2,15.08],
["1af7H",2,15.37],
["1d3yH",2,15.38],
["1icfH",2,15.4],
["1ogsH",2,15.5],
["1g38H",2,15.58],
["1bifH",2,15.6],
["1hhsH",2,15.7],
["1i4mH",2,15.7],
["1h3fH",2,16.030001],
["1e8cH",2,16.030001],
["1mgpH",2,16.16],
["1ic2H",2,16.549999],
["1amxH",2,16.57],
["1el6H",2,16.58],
["1tigH",2,16.66],
["1h6kH",2,17.030001],
["1knqH",2,17.23],
["1pswH",2,17.33],
["2dtrH",2,17.34],
["1ofdH",2,17.58],
["1rl6H",2,17.620001],
["1h8eH",2,17.700001],
["1ohtH",2,17.809999],
["1oacH",2,18.040001],
["1jr7H",2,18.049999],
["1dqaH",2,18.15],
["2ptdH",2,18.24],
["1d8cH",2,18.469999],
["1jc4H",2,18.540001],
["1nigH",2,19.120001],
["1hufH",2,19.6],
["1g2fH",2,19.74],
["1gotH",2,19.85],
["1kcmH",2,19.870001],
["1g73H",2,19.92],
["1kmoH",2,20.01],
["1nf5H",2,20.219999],
["1k8kH",2,20.42],
["1m5iH",2,20.77],
["1sacH",2,21.360001],
["1bhtH",2,21.65],
["1n7zH",2,21.809999],
["1kpgH",2,21.870001],
["1io1H",2,22.059999],
["1iegH",2,22.24],
["1cewH",2,22.440001],
["1hf8H",2,23.030001],
["1e7uH",2,23.07],
["1whtH",2,23.08],
["1mzgH",2,23.299999],
["1or7H",2,23.4],
["1bkcH",2,23.690001],
["1dj8H",2,23.99],
["1fviH",2,24.540001],
["1czyH",2,24.85],
["1k32H",2,24.860001],
["1eziH",2,24.889999],
["1qjbH",2,25.309999],
["1gxjH",2,25.4],
["1fmtH",2,25.440001],
["1byrH",2,25.450001],
["1nxzH",2,25.48],
["1aocH",2,25.780001],
["1gefH",2,26.190001],
["1mu5H",2,26.620001],
["1dm9H",2,26.629999],
["1mkiH",2,26.629999],
["1spbH",2,28.209999],
["1f3vH",2,28.309999],
["1fp3H",2,28.52],
["1o0sH",2,28.559999],
["1kp8H",2,28.9],
["1ia9H",2,29.610001],
["1pocH",2,30.25],
["1dceH",2,30.709999],
["1ff9H",2,31.110001],
["1lcyH",2,31.120001],
["1lddH",2,31.88],
["1h1rH",2,33.17],
["1l2lH",2,33.51],
["1nkzH",2,33.76],
["1d2oH",2,34.04],
["1i8dH",2,34.22],
["1dfaH",2,36.66],
["1d8hH",2,38.33],
["1g7sH",2,39.3],
["1nijH",2,40.7],
["1f83H",2,44.92],
["1dd3H",2,44.94],
["1a77H",2,45.76],
["1m1gH",2,50.06],
["1m3yH",2,50.52],
["1k87H",2,52.91],
["1dtjH",2,53.22],
["1mscH",2,57.54],
["1eayH",2,62.11],
["1l6kH",2,80.69],
["1jc9H",2.01,15.55],
["1n2fH",2.01,16.07],
["1li4H",2.01,18.879999],
["1evuH",2.01,20.040001],
["1l0wH",2.01,25.92],
["1nw1H",2.02,14.04],
["1fqjH",2.02,15.27],
["1f3lH",2.03,16.09],
["1k24H",2.03,44.32],
["1jtkH",2.04,11.48],
["1qi9H",2.05,7.44],
["1dkqH",2.05,21.940001],
["1go4H",2.05,39.28],
["1f44H",2.05,40.24],
["1lt8H",2.05,49.69],
["1aa7H",2.0799999,23.49],
["1c94H",2.0799999,36],
["1coiH",2.0999999,4.26],
["2tctH",2.0999999,7.48],
["1thtH",2.0999999,9.32],
["16vpH",2.0999999,11.47],
["1gl1H",2.0999999,11.57],
["1ax4H",2.0999999,11.64],
["1kloH",2.0999999,12.55],
["1a8rH",2.0999999,12.7],
["1dmtH",2.0999999,12.75],
["1qd6H",2.0999999,12.98],
["1e8gH",2.0999999,13.08],
["1ldfH",2.0999999,13.15],
["1kwsH",2.0999999,13.75],
["4sgbH",2.0999999,13.98],
["1lhpH",2.0999999,14.3],
["1k4tH",2.0999999,14.49],
["1br9H",2.0999999,14.59],
["1lrzH",2.0999999,15.12],
["1m1eH",2.0999999,15.48],
["1dcqH",2.0999999,15.62],
["1rmdH",2.0999999,15.89],
["1dyoH",2.0999999,16.82],
["1n81H",2.0999999,17.02],
["1h09H",2.0999999,17.120001],
["1qmhH",2.0999999,17.25],
["1smfH",2.0999999,17.290001],
["1eucH",2.0999999,17.540001],
["1uadH",2.0999999,17.879999],
["1brwH",2.0999999,18.59],
["1omzH",2.0999999,18.77],
["1j1vH",2.0999999,18.82],
["1ed1H",2.0999999,18.9],
["1h5wH",2.0999999,19.42],
["1fs0H",2.0999999,19.469999],
["1a32H",2.0999999,19.690001],
["1isiH",2.0999999,20.040001],
["1h59H",2.0999999,20.809999],
["1dq3H",2.0999999,20.83],
["1ewnH",2.0999999,21.43],
["2e2aH",2.0999999,21.91],
["1mkfH",2.0999999,22.049999],
["1lf6H",2.0999999,22.200001],
["1m98H",2.0999999,22.379999],
["1accH",2.0999999,23.49],
["1escH",2.0999999,23.73],
["1ep3H",2.0999999,25.860001],
["1ofuH",2.0999999,26.07],
["1aisH",2.0999999,26.610001],
["1ek9H",2.0999999,27.120001],
["1a3qH",2.0999999,29.120001],
["2cblH",2.0999999,29.860001],
["1otgH",2.0999999,30.700001],
["1d09H",2.0999999,33.73],
["1cosH",2.0999999,35.27],
["1iznH",2.0999999,37.08],
["1heiH",2.0999999,41.46],
["1f2vH",2.0999999,47.56],
["1jl5H",2.0999999,51.2],
["1mswH",2.0999999,63.68],
["1lvaH",2.1199999,17.879999],
["1n0uH",2.1199999,33.94],
["1h1oH",2.1300001,45.46],
["1i5nH",2.1400001,12.93],
["1in0H",2.1400001,29.129999],
["1h2kH",2.1500001,9.8],
["1cfrH",2.1500001,14.04],
["1k3bH",2.1500001,18.35],
["1ocxH",2.1500001,18.4],
["1dvkH",2.1500001,19.17],
["1h54H",2.1500001,19.450001],
["1ezfH",2.1500001,21.049999],
["1b8kH",2.1500001,23.16],
["1nvvH",2.1800001,11.5],
["1ednH",2.1800001,88.15],
["1bjaH",2.1900001,20.870001],
["1kwiH",2.1900001,25.49],
["1ecmH",2.2,7.82],
["1smtH",2.2,7.88],
["1qc7H",2.2,8.32],
["1p5hH",2.2,8.83],
["1ixcH",2.2,8.91],
["1cxzH",2.2,9.25],
["1llaH",2.2,9.28],
["1dhsH",2.2,10.73],
["1qfhH",2.2,10.92],
["1aw8H",2.2,11.07],
["1efyH",2.2,11.56],
["1dmuH",2.2,11.82],
["1iexH",2.2,12.07],
["2irfH",2.2,12.21],
["1im3H",2.2,12.22],
["1nv8H",2.2,12.37],
["1qamH",2.2,13.79],
["1gmlH",2.2,13.93],
["1j7lH",2.2,14.01],
["1gpmH",2.2,14.14],
["1dkuH",2.2,14.44],
["1i8nH",2.2,14.91],
["1gmjH",2.2,15.66],
["1ii7H",2.2,16.15],
["1kjnH",2.2,16.57],
["1lnsH",2.2,16.66],
["1jlxH",2.2,16.860001],
["1xvaH",2.2,16.879999],
["1cfzH",2.2,17.049999],
["1qrvH",2.2,17.290001],
["1f7uH",2.2,17.559999],
["1phzH",2.2,17.709999],
["1ihnH",2.2,18.129999],
["1kyqH",2.2,18.34],
["1no4H",2.2,18.379999],
["1m4zH",2.2,18.98],
["1n7vH",2.2,19.09],
["1bouH",2.2,19.879999],
["1n4kH",2.2,19.940001],
["1n69H",2.2,20.26],
["1p35H",2.2,20.84],
["1iicH",2.2,20.959999],
["1i5pH",2.2,21.469999],
["1qlaH",2.2,21.48],
["1em2H",2.2,21.549999],
["1is2H",2.2,21.690001],
["1a5tH",2.2,21.85],
["1l8dH",2.2,22.309999],
["1imjH",2.2,22.709999],
["1tulH",2.2,22.809999],
["1i3jH",2.2,23.299999],
["1jocH",2.2,23.309999],
["1vmoH",2.2,24.74],
["1is1H",2.2,25.049999],
["1jvsH",2.2,25.559999],
["1hw7H",2.2,25.92],
["1h6pH",2.2,27.09],
["1oxwH",2.2,27.23],
["1devH",2.2,27.309999],
["1im8H",2.2,27.530001],
["1kuuH",2.2,29],
["1jmtH",2.2,29.459999],
["1tyfH",2.2,29.700001],
["1ewqH",2.2,31.379999],
["1gkzH",2.2,32.17],
["1f6yH",2.2,32.36],
["1xxaH",2.2,33.35],
["1mazH",2.2,33.88],
["1iq8H",2.2,34.7],
["1pfoH",2.2,35.02],
["1hf2H",2.2,35.18],
["1ycsH",2.2,37.97],
["1mkmH",2.2,45.56],
["1g9mH",2.2,47.45],
["1k1fH",2.2,57.93],
["1grjH",2.2,59.24],
["1bpyH",2.2,60.46],
["1mbxH",2.25,9.23],
["1c8nH",2.25,10.36],
["1ignH",2.25,12.84],
["1js3H",2.25,14.44],
["1qo0H",2.25,15.43],
["1jqiH",2.25,21.790001],
["1k78H",2.25,23.24],
["1p32H",2.25,25.290001],
["1bg1H",2.25,27.610001],
["1fi4H",2.27,25.190001],
["1oc0H",2.28,7.58],
["1a79H",2.28,31.129999],
["1nx8H",2.3,4.6],
["2rebH",2.3,6.49],
["1j5yH",2.3,9.18],
["1f35H",2.3,9.92],
["1am7H",2.3,10.22],
["1b33H",2.3,11.15],
["1k4zH",2.3,13.03],
["1jtdH",2.3,13.51],
["1l1sH",2.3,13.65],
["2occH",2.3,13.9],
["1ezvH",2.3,14.58],
["1fxkH",2.3,16.459999],
["1ik9H",2.3,16.68],
["1l3aH",2.3,16.799999],
["1g71H",2.3,16.91],
["1kcfH",2.3,17.110001],
["1gzsH",2.3,18.219999],
["1ycqH",2.3,19.1],
["1js8H",2.3,19.469999],
["1obrH",2.3,20.18],
["1jk4H",2.3,20.23],
["1dbhH",2.3,20.360001],
["2rslH",2.3,21.32],
["1jsuH",2.3,21.77],
["1g31H",2.3,21.83],
["1rl2H",2.3,23.129999],
["1j6rH",2.3,23.48],
["1b79H",2.3,24.200001],
["1l0bH",2.3,25.110001],
["1qexH",2.3,26.440001],
["1fjrH",2.3,27.33],
["2prgH",2.3,29.26],
["2fokH",2.3,29.530001],
["1j7nH",2.3,30.18],
["1djxH",2.3,30.91],
["1nbfH",2.3,33.3],
["1lp1H",2.3,35.43],
["1l0sH",2.3,37.92],
["1l8wH",2.3,38.25],
["1lssH",2.3,41.61],
["1qdmH",2.3,41.88],
["1dcpH",2.3,41.95],
["1m41H",2.3,43.18],
["1biaH",2.3,45.74],
["1e5rH",2.3,46.29],
["4htcH",2.3,48.5],
["1m56H",2.3,50.93],
["1a2xH",2.3,53.17],
["1gd8H",2.3,56.31],
["1bl0H",2.3,60.68],
["1kitH",2.3,62.05],
["1k3rH",2.3,66.09],
["1f3mH",2.3,69.32],
["1ltqH",2.3299999,31.7],
["1jqnH",2.3499999,20.23],
["1l0lH",2.3499999,38.07],
["1bu6H",2.3699999,73.1],
["1a9nH",2.3800001,19.309999],
["1lj2H",2.3800001,22.41],
["1ev7H",2.3800001,31.15],
["1no1H",2.4000001,3.37],
["1debH",2.4000001,9.51],
["1af6H",2.4000001,10.46],
["1f8yH",2.4000001,11.52],
["1a8yH",2.4000001,11.72],
["1pfkH",2.4000001,11.9],
["1l5jH",2.4000001,14.78],
["1n1cH",2.4000001,15.11],
["1n8yH",2.4000001,15.46],
["1jmmH",2.4000001,15.75],
["1i8tH",2.4000001,15.8],
["1eaiH",2.4000001,16.1],
["1qgoH",2.4000001,16.43],
["1kiyH",2.4000001,17.940001],
["1bcoH",2.4000001,18.25],
["1cbfH",2.4000001,19.35],
["1e44H",2.4000001,20.42],
["1loxH",2.4000001,20.42],
["1ifqH",2.4000001,20.49],
["1l0qH",2.4000001,21.049999],
["1k6yH",2.4000001,21.450001],
["1hi9H",2.4000001,21.52],
["1qiuH",2.4000001,21.639999],
["1qmeH",2.4000001,21.889999],
["1qtqH",2.4000001,21.9],
["1f1zH",2.4000001,22.030001],
["1qpoH",2.4000001,22.290001],
["1iu4H",2.4000001,22.959999],
["1colH",2.4000001,23.82],
["1jj2H",2.4000001,24.58],
["1ot5H",2.4000001,25.860001],
["1nbwH",2.4000001,26.110001],
["1ipaH",2.4000001,26.559999],
["2trcH",2.4000001,27.040001],
["1k1xH",2.4000001,27.110001],
["1ehkH",2.4000001,27.17],
["1h3qH",2.4000001,27.620001],
["1o9lH",2.4000001,28.450001],
["1jsxH",2.4000001,28.549999],
["1qs0H",2.4000001,28.91],
["1htqH",2.4000001,30.110001],
["1nd6H",2.4000001,30.73],
["1hnnH",2.4000001,30.85],
["1jadH",2.4000001,34.5],
["1avqH",2.4000001,34.77],
["1epuH",2.4000001,38.98],
["1f89H",2.4000001,40.12],
["1kkhH",2.4000001,41.72],
["1jalH",2.4000001,46.06],
["1jogH",2.4000001,50.85],
["1ubyH",2.4000001,63.05],
["1hh0H",2.4000001,115.27],
["1k47H",2.4200001,26.23],
["1m4uH",2.4200001,39.61],
["1hc7H",2.4300001,14.85],
["1gz5H",2.4300001,17.790001],
["1hk8H",2.45,6.31],
["1ei7H",2.45,31.059999],
["1knzH",2.45,33.46],
["1lpbH",2.46,29.629999],
["1ejfH",2.49,16.309999],
["1fuiH",2.5,11.23],
["1ckmH",2.5,11.49],
["1b5tH",2.5,11.74],
["1pyaH",2.5,11.81],
["1sryH",2.5,11.88],
["1g99H",2.5,14.65],
["2polH",2.5,15.93],
["1ytfH",2.5,16.129999],
["1nw3H",2.5,16.219999],
["1a7jH",2.5,16.860001],
["1di1H",2.5,17.43],
["1qhxH",2.5,17.959999],
["1cmiH",2.5,17.969999],
["1jofH",2.5,18.84],
["1efuH",2.5,19.559999],
["1e3pH",2.5,20.190001],
["1o12H",2.5,21.469999],
["1bjtH",2.5,22.049999],
["1auaH",2.5,22.49],
["1hlvH",2.5,22.700001],
["1jeyH",2.5,22.860001],
["2pvaH",2.5,23.030001],
["1bt3H",2.5,23.280001],
["1e5dH",2.5,23.32],
["1nknH",2.5,23.469999],
["1rlrH",2.5,24.5],
["1cliH",2.5,25.07],
["1gy9H",2.5,26.370001],
["1iuhH",2.5,27.030001],
["1jb0H",2.5,27.52],
["1efnH",2.5,28.200001],
["1f5aH",2.5,28.74],
["1zymH",2.5,29.780001],
["1f6dH",2.5,30.059999],
["1o7fH",2.5,30.629999],
["1zmeH",2.5,31.280001],
["1kzyH",2.5,31.72],
["1m2oH",2.5,31.85],
["1cjyH",2.5,32.09],
["1i31H",2.5,32.2],
["1dcfH",2.5,34.99],
["1bdfH",2.5,35.26],
["1nniH",2.5,35.41],
["1b4aH",2.5,37.79],
["1oqeH",2.5,39.11],
["1i4dH",2.5,41.52],
["1p1cH",2.5,42.66],
["1qpzH",2.5,42.67],
["1fx3H",2.5,44.17],
["1dabH",2.5,44.85],
["1dm0H",2.5,44.96],
["1knyH",2.5,46.2],
["1kpsH",2.5,49.5],
["1b7yH",2.5,54.14],
["1hjrH",2.5,55.73],
["1sknH",2.5,60.85],
["1kfuH",2.5,67.91],
["1otsH",2.51,44.9],
["1c0mH",2.53,34.58],
["1914H",2.53,37.08],
["1l5aH",2.55,25.370001],
["1p0yH",2.55,38.61],
["1gtdH",2.5599999,27.92],
["1mmsH",2.5699999,30.65],
["1gw5H",2.5899999,33.9],
["1ml8H",2.5999999,9.93],
["1jg5H",2.5999999,13.43],
["1cbyH",2.5999999,14.33],
["1ixmH",2.5999999,14.36],
["1kkeH",2.5999999,14.4],
["1hstH",2.5999999,15.46],
["1k2fH",2.5999999,16.35],
["1nktH",2.5999999,17.02],
["1bvpH",2.5999999,17.209999],
["1h8lH",2.5999999,19.950001],
["1avgH",2.5999999,20.48],
["1o70H",2.5999999,23.040001],
["1ebdH",2.5999999,23.809999],
["1lktH",2.5999999,23.99],
["1i78H",2.5999999,24.639999],
["1b3qH",2.5999999,24.73],
["1kc6H",2.5999999,25.25],
["1a6dH",2.5999999,25.799999],
["1hynH",2.5999999,26.65],
["1h9dH",2.5999999,27.73],
["1h0xH",2.5999999,29.01],
["1k8tH",2.5999999,31.299999],
["1b89H",2.5999999,33.06],
["1ft9H",2.5999999,33.55],
["1l9vH",2.5999999,33.96],
["1lxaH",2.5999999,34.38],
["1lrvH",2.5999999,35.57],
["1irxH",2.5999999,37.04],
["1lnzH",2.5999999,38.14],
["1cf7H",2.5999999,41.59],
["1ngvH",2.5999999,41.9],
["1divH",2.5999999,42.42],
["1repH",2.5999999,44.09],
["1c4zH",2.5999999,49.63],
["1hcnH",2.5999999,50.39],
["1nekH",2.5999999,53.2],
["1eulH",2.5999999,53.27],
["1g1xH",2.5999999,55.25],
["1l9hH",2.5999999,63.47],
["1bpoH",2.5999999,65.87],
["1jopH",2.5999999,72.35],
["1iw7H",2.5999999,89.58],
["1qu7H",2.5999999,96.19],
["1j1dH",2.6099999,52.1],
["1lrrH",2.6500001,30.99],
["1keyH",2.6500001,38.16],
["1ni5H",2.6500001,38.23],
["1m9sH",2.6500001,47.99],
["1hkxH",2.6500001,48.02],
["1yrgH",2.6600001,22.860001],
["1qm4H",2.6600001,45.93],
["1c4kH",2.7,9.2],
["2vsgH",2.7,19.690001],
["1ddlH",2.7,22.610001],
["4kbpH",2.7,23.68],
["1gmeH",2.7,25.25],
["1aepH",2.7,26.959999],
["1ecrH",2.7,28.84],
["1k8qH",2.7,31.51],
["1i9bH",2.7,32.56],
["1k5dH",2.7,33.56],
["1h2iH",2.7,34.36],
["1d5yH",2.7,36.03],
["1d7mH",2.7,36.12],
["1bowH",2.7,39.48],
["1anvH",2.7,44.44],
["1gkuH",2.7,46.56],
["1bcpH",2.7,48.05],
["1kgyH",2.7,54.97],
["1c3gH",2.7,59.71],
["1dt9H",2.7,70.93],
["1psdH",2.75,23.01],
["1jbgH",2.75,34.64],
["1pkpH",2.8,15.82],
["1avoH",2.8,19.85],
["1jmuH",2.8,22.42],
["1g8xH",2.8,32.11],
["1fyxH",2.8,33.67],
["1b04H",2.8,38.83],
["1de4H",2.8,39.48],
["1f59H",2.8,39.6],
["1omiH",2.8,40.17],
["1ebpH",2.8,41.1],
["1preH",2.8,41.48],
["1i50H",2.8,43.83],
["1mhdH",2.8,44.84],
["1ku9H",2.8,50.61],
["1fqvH",2.8,52.63],
["2bbvH",2.8,57.77],
["1dkgH",2.8,70.02],
["1cr6H",2.8,70.24],
["1tdjH",2.8,80.4],
["1hekH",2.8,122.82],
["1jpyH",2.8499999,30.6],
["1j5sH",2.8499999,40.68],
["1mr1H",2.8499999,43.29],
["1odhH",2.8499999,45.26],
["1dgsH",2.9000001,25.110001],
["1cjaH",2.9000001,29.969999],
["1n10H",2.9000001,34.64],
["1qf6H",2.9000001,35.39],
["1nkvH",2.9000001,35.82],
["1mi1H",2.9000001,38.14],
["1kmiH",2.9000001,40.44],
["1fo1H",2.9000001,42.56],
["1ir6H",2.9000001,43.64],
["1i1gH",2.9000001,44.5],
["1f02H",2.9000001,46.03],
["1k28H",2.9000001,46.32],
["1nuiH",2.9000001,47.53],
["4dpvH",2.9000001,47.85],
["1nt2H",2.9000001,60.56],
["1ivsH",2.9000001,63.2],
["1dfcH",2.9000001,65.55],
["1jhnH",2.9000001,90.52],
["1o0uH",2.95,6.87],
["1ngmH",2.95,29.219999],
["1oy1H",2.95,31.09],
["1ho8H",2.95,141.48],
["1miwH",3,20],
["1ny7H",3,20.17],
["1g0yH",3,29.860001],
["1ciiH",3,30.299999],
["1ltlH",3,33.84],
["1bmtH",3,36.11],
["1bo1H",3,38.46],
["1m5yH",3,38.88],
["2bpaH",3,41.13],
["1ij5H",3,41.83],
["1huxH",3,46.54],
["1qojH",3,56.17],
["1fezH",3,56.59],
["1c8bH",3,57.03],
["1ko6H",3,73.86],
["1ldjH",3,103.4],
["1jchH",3.02,111.02],
["1nyhH",3.0999999,7.46],
["1jv2H",3.0999999,53.42],
["1lb2H",3.0999999,59.76],
["1miuH",3.0999999,89.39],
["1iblH",3.1099999,50.92],
["1cdzH",3.2,41.83],
["1l7vH",3.2,49.52],
["1f15H",3.2,53.69],
["1flcH",3.2,71.76],
["1gm5H",3.24,163.44],
["1eiyH",3.3,54.75],
["1g5gH",3.3,64.47],
["1qgtH",3.3,101.57],
["1hqmH",3.3,130.42999],
["1ihmH",3.4,26.309999],
["1oyeH",3.48,22.799999],
["2btvH",3.5,31.35],
["1al0H",3.5,56.72],
["1mslH",3.5,60.69],
["1m1cH",3.5,73.08]]
